<?php include("loginChecker.php"); ?>
<?php require_once '../connections/meekro/db.class.php'; ?>

<?php

try {
    // Monthly data grouped by month and year for 2023-2025
    $monthly_data = DB::query("
        SELECT 
            year AS year,
            month AS month,
            SUM(amount) AS total_amount
        FROM year_to_date
        WHERE year IN (2023, 2024, 2025)
        GROUP BY year, month
        ORDER BY year, month
    ");

    // Totals per year
    $yearly_totals = DB::query("
        SELECT 
            YEAR(year) AS year,
            SUM(amount) AS yearly_total
        FROM year_to_date
        WHERE YEAR(year) IN (2023, 2024, 2025)
        GROUP BY year
    ");

    header('Content-Type: application/json');
    echo json_encode([
        "monthly" => $monthly_data,
        "yearly_totals" => $yearly_totals
    ]);
} catch (Exception $e) {
    echo json_encode(["error" => "Database error: " . $e->getMessage()]);
}
?>
