<?php include("loginChecker.php"); ?>
<?php require_once '../connections/meekro/db.class.php'; ?>

<?php
try {
    // Fetch the total values
    $totals = DB::queryFirstRow("
        SELECT 
            SUM(no_declaration) AS total_declarations,
            SUM(no_containers) AS total_containers,
            SUM(revenue_generated) AS total_generated,
            SUM(revenue_collected) AS total_collected
        FROM fast_track
    ");

    // Fetch detailed data for the bar chart
    $results = DB::query("SELECT transaction_date, revenue_generated, revenue_collected FROM fast_track ORDER BY transaction_date ASC");

    header('Content-Type: application/json');
    echo json_encode(["totals" => $totals, "data" => $results]);
} catch (Exception $e) {
    echo json_encode(["error" => "Database error: " . $e->getMessage()]);
}
?>
