<?php include("loginChecker.php"); ?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Web3 Dashboard</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="../css/style.css" />
    <style>
           </style>
</head>
<body>
    <div class="toggle-btn" onclick="toggleSidebar()">
        <i class="fas fa-bars"></i>
    </div>

    <div class="sidebar" id="sidebar">
      <!-- Logo section -->
      <div class="text-center mb-3">
        <img src="../images/logo.jpg" alt="Logo" style="width: 80px; height: auto; margin-bottom: 5px;">
        <h6 class="mb-0">APAPA AREA COMMAND</h6>
        <p class="fs-6 p-0 m-0 text-success">Research & Development Office</p>
      </div>
    
      <!-- Navigation links -->
        <a href="index.php" class="nav-link"><i class="fa fa-chart-line"></i> <span>Revenue</span></a>
        <a href="fast_track.php" class="nav-link"><i class="fa fa-fast-forward"></i> <span>Fast-Track</span></a>
        <a href="#" class="nav-link"><i class="fa fa-file-alt"></i> <span>PAAR</span></a>
        <a href="#" class="nav-link"><i class="fa fa-tachometer-alt"></i> <span>KPIs</span></a>
        <a href="logout.php" class="nav-link"><i class="fa fa-sign-out"></i> <span>Logout</span></a>
    </div>

    <div class="main-content pt-0">
        <div class="row m-0">
            <div class="d-flex justify-content-between align-items-center mb-3 bg-success">
                <h4 class="text-white">Fast-Track </h4>
                <button id="darkModeToggle" class="btn btn-sm btn-outline-light" style="background: none; border: none; color: white; font-size: 20px;">
                  <i class="fas fa-moon" id="darkModeIcon"></i>
                </button>
            </div>

        </div>
        <div class="row">
            <div class="col-md-3">
                <div class="card mb-4">
                  <div class="card-body">
                    <div class="d-flex flex-nowrap justify-content-between">
                      <h6 class="card-title text-body-secondary text-truncate" data-coreui-i18n="orders">Declarations</h6>
                      <div class="bg-info bg-opacity-25 text-info p-2 rounded ms-2">
                        <i class="fa-solid fa-list"></i>
                      </div>
                    </div>
                    <div class="fs-4 fw-semibold pb-3 text-center counter" id="totalDeclarations"></div>
                    <small class="text-success">
                        (17.2%  )
                    </small>
                  </div>
                </div>
              </div>

              <div class="col-md-3">
                <div class="card mb-4">
                  <div class="card-body">
                    <div class="d-flex flex-nowrap justify-content-between">
                      <h6 class="card-title text-body-secondary text-truncate" data-coreui-i18n="orders">Containers</h6>
                      <div class="bg-warning bg-opacity-25 text-warning p-2 rounded ms-2">
                        <i class="fa-solid fa-truck-moving"></i>
                      </div>
                    </div>
                    <div class="fs-4 fw-semibold pb-3 text-center counter" id="totalContainers"></div>
                    <small class="text-success">(17.2%)</small>
                  </div>
                </div>
              </div>

              <div class="col-md-3">
                <div class="card mb-4">
                  <div class="card-body">
                    <div class="d-flex flex-nowrap justify-content-between">
                      <h6 class="card-title text-body-secondary text-truncate" data-coreui-i18n="orders">Generated</h6>
                      <div class="bg-danger bg-opacity-50 text-white p-2 rounded ms-2">
                        <i class="fa-solid fa-file-invoice-dollar"></i>
                      </div>
                    </div>
                    <div class="fs-4 fw-semibold pb-3 text-center" >
                      <span>₦</span> <span class="counter" id="totalGenerated"> </span>
                    </div>
                    <small class="text-success">(17.2%)</small>
                  </div>
                </div>
              </div>

              <div class="col-md-3">
                <div class="card mb-4">
                  <div class="card-body">
                    <div class="d-flex flex-nowrap justify-content-between">
                      <h6 class="card-title text-body-secondary text-truncate" data-coreui-i18n="orders">Collected</h6>
                      <div class="bg-success bg-opacity-25 text-success p-2 rounded ms-2">
                        <i class="fa-solid fa-check-to-slot"></i>
                      </div>
                    </div>
                    <div class="fs-4 fw-semibold pb-3 text-center">
                      <span>₦</span> <span class="counter" id="totalCollected"> </span>
                    </div>
                    <small class="text-success">(17.2%
                      )</small>
                  </div>
                </div>
              </div>  
        </div>

        <div class="row px-3 my-2">
          <hr class="mb-0">
            <div class="d-flex justify-content-between align-items-baseline">
              <div class="fw-semibold">37% Collected</div>
              <div class="text-nowrap small text-body-secondary ms-3"><span data-coreui-i18n-date="dateShortMonthName, { 'date': '2023, 6, 11'}">Feb 01, 2025</span> - <span data-coreui-i18n-date="dateShortMonthName, { 'date': '2023, 7, 10'}">Feb 17, 2025</span></div>
            </div>
            <div class="progress progress-thin mt-1 px-0 col-12">
              <div class="progress-bar bg-success" role="progressbar" style="width: 37%" aria-valuenow="37" aria-valuemin="0" aria-valuemax="100"></div>
            </div>
          
        </div>
       

        <div class="card mb-4 report" id="revenue"  style="display: block;">
            <div class="card-header"><strong>Revenue Generated  </strong><span class="small ms-1">vs</span> <strong> Revenue Collected </strong></div>
            <div class="card-body">
              <div class="example">
                
                
                    <div class="c-chart-wrapper">
                      <canvas id="revenueChart" width="320" height="100" style="display: block; box-sizing: border-box; height: 128px; width: 256px;"></canvas>
                    </div>
                 
              </div>
            </div>
        </div>

       
    </div>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://kit.fontawesome.com/d9c9660a46.js" crossorigin="anonymous"></script>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/jquery.counterup@2.1.0/jquery.counterup.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/waypoints/4.0.1/jquery.waypoints.min.js"></script>
    <script>
      $(document).ready(function(){
          $('.counter').counterUp({
              delay: 6, // Speed of counting
              time: 3000 // Duration of animation
          });
      });

      // Highlight the active nav link
      const links = document.querySelectorAll('.sidebar a');
        const currentPage = window.location.pathname.split('/').pop();

        links.forEach(link => {
            if (link.getAttribute('href') === currentPage) {
            link.classList.add('active');
            }
        });
  </script>

<script>
    const toggleBtn = document.getElementById('darkModeToggle');
    const icon = document.getElementById('darkModeIcon');
  
    // Function to apply dark mode and update icon
    function applyDarkMode(isDark) {
      document.body.classList.toggle('dark-mode', isDark);
      icon.classList.remove('fa-sun', 'fa-moon');
      icon.classList.add(isDark ? 'fa-sun' : 'fa-moon');
    }
  
    // Load saved mode on page load
    const savedMode = localStorage.getItem('darkMode');
    const isDarkMode = savedMode === 'true' || (!savedMode && window.matchMedia('(prefers-color-scheme: dark)').matches);
    applyDarkMode(isDarkMode);
  
    // Toggle and save on click
    toggleBtn.addEventListener('click', function () {
      const isDark = document.body.classList.toggle('dark-mode');
      localStorage.setItem('darkMode', isDark);
      icon.classList.remove('fa-sun', 'fa-moon');
      icon.classList.add(isDark ? 'fa-sun' : 'fa-moon');
    });
  </script>
    <script>
        function toggleSidebar() {
            document.getElementById("sidebar").classList.toggle("collapsed");
        }

       

        function fetchData() {
            $.ajax({
                url: 'fast_track_model.php',
                method: 'GET',
                dataType: 'json',
                success: function(response) {

                    // Update totals
                $('#totalDeclarations').text(Number(response.totals.total_declarations).toLocaleString(undefined, { minimumFractionDigits: 2, maximumFractionDigits: 2 }));
                $('#totalContainers').text(Number(response.totals.total_containers).toLocaleString(undefined, { minimumFractionDigits: 2, maximumFractionDigits: 2 }));
                // Update totals with number formatting
                $('#totalGenerated').text(Number(response.totals.total_generated).toLocaleString(undefined, { minimumFractionDigits: 2, maximumFractionDigits: 2 }));
                $('#totalCollected').text(Number(response.totals.total_collected).toLocaleString(undefined, { minimumFractionDigits: 2, maximumFractionDigits: 2 }));


                    let labels = response.data.map(item => item.transaction_date);
                    let declarations = response.data.map(item => item.no_declaration);
                    let containers = response.data.map(item => item.no_containers);
                    let revenueGenerated = response.data.map(item => item.revenue_generated);
                    let revenueCollected = response.data.map(item => item.revenue_collected);
                    let percentage = response.data.map(item => item.percentage);

                    new Chart(document.getElementById('revenueChart'), {
                        type: 'bar',
                        data: { labels, datasets: [
                            { label: 'Generated', data: revenueGenerated, backgroundColor: '#657b8b' },
                            { label: 'Collected', data: revenueCollected, backgroundColor: '#878b92' }
                        ]}
                    });

                   
                },
                error: function(err) {
                    console.log('Error fetching data:', err);
                }
            });
        }

        $(document).ready(fetchData);
    </script>

</body>
</html>
