<?php
require_once '../../connections/meekro/db.class.php';

$currentMonth = $_GET['month'] ?? date('n');
$currentYear = $_GET['year'] ?? date('Y');


$weekly = DB::query("
  SELECT 
    WEEK(reg_date, 1) AS week_number,
    MIN(reg_date) AS week_start,
    MAX(reg_date) AS week_end,
    SUM(sgd) AS total_sgd,
    SUM(ecash) AS total_ecash,
    ROUND(AVG(percentage), 2) AS avg_percentage
  FROM monthly
  WHERE MONTH(reg_date) = %i AND YEAR(reg_date) = %i
  GROUP BY WEEK(reg_date, 1)
  ORDER BY week_number
", $currentMonth, $currentYear);

header('Content-Type: application/json');
echo json_encode(['weekly' => $weekly]);
?>
