<?php
require_once '../../connections/meekro/db.class.php';

header('Content-Type: application/json');

$rows = DB::query("SELECT year, month, amount 
                   FROM year_to_date 
                   ORDER BY FIELD(month, 'January','February','March','April','May','June','July','August','September','October','November','December'), year");

$years = [2023, 2024, 2025];
$months = ['January','February','March','April','May','June','July','August','September','October','November','December'];

// Initialize structured data
$data = [];
foreach ($months as $month) {
    $row = ['month' => $month];
    foreach ($years as $year) {
        $row[$year] = 0;
    }
    $data[$month] = $row;
}

// Populate with actual data
foreach ($rows as $row) {
    $m = $row['month'];
    $y = $row['year'];
    $v = (float) $row['amount'];
    if (isset($data[$m][$y])) {
        $data[$m][$y] = $v;
    }
}

// Convert associative array to indexed array
echo json_encode(array_values($data));
?>
