<?php
require_once '../../connections/meekro/db.class.php';

$currentYear = $_GET['year'] ?? date('Y');

try {
    $results = DB::query("
        SELECT 
            QUARTER(transaction_date) AS quarter,
            SUM(no_declaration) AS total_declarations,
            SUM(no_containers) AS total_containers,
            SUM(revenue_collected) AS total_collected
        FROM fast_track
         WHERE YEAR(transaction_date) = '$currentYear'
        GROUP BY quarter
        ORDER BY quarter ASC
    ");

    $response = [];
    foreach ($results as $row) {
        $response[] = [
            'quarter' => 'Q' . $row['quarter'],
            'total_declarations' => (int)$row['total_declarations'],
            'total_containers' => (int)$row['total_containers'],
            'total_collected' => (float)$row['total_collected']
        ];
    }

    header('Content-Type: application/json');
    echo json_encode($response);
} catch (Exception $e) {
    echo json_encode(["error" => "Database error: " . $e->getMessage()]);
}
