<?php
require_once '../../connections/meekro/db.class.php';

$currentMonth = $_GET['month'] ?? date('n'); //1-12
$currentYear = $_GET['year'] ?? date('Y');

$currentMonth =5;
$results = DB::query("
  SELECT 
    reg_date, 
    sgd, 
    ecash, 
    percentage 
  FROM monthly 
  WHERE MONTH(reg_date) = %i AND YEAR(reg_date) = %i 
  ORDER BY reg_date
", $currentMonth, $currentYear);

$labels = [];
$sgd = [];
$ecash = [];
$percentage = [];

foreach ($results as $row) {
    $labels[] = date('M j', strtotime($row['reg_date']));
    $sgd[] = (float) $row['sgd'];
    $ecash[] = (float) $row['ecash'];
    $percentage[] = (float) $row['percentage'];
}

header('Content-Type: application/json');
echo json_encode([
  'labels' => $labels,
  'sgd' => $sgd,
  'ecash' => $ecash,
  'percentage' => $percentage
]);
?>
