<?php
    use PHPMailer\PHPMailer\PHPMailer;
    use PHPMailer\PHPMailer\SMTP;
    use PHPMailer\PHPMailer\Exception;
        
    function localTyme($time){
        $localTime = date('h:i A', strtotime($time));
        if (empty($time)) {
            $localTime = "N/A";
            return $localTime;
        }else{
            return $localTime;
        }
        
    }

     function localDate($date){
        $localDate = date('d/m/Y', strtotime($date));
        if (empty($date)) {
            $localDate = "N/A";
            return $localDate;
        }else{
            return $localDate;
        }
    }
    
     function displayStatus($status, $reason){
        if($status == "Active" || $status == "Approved" || $status == "Reviewed" || $status == "Validated"){
            echo '
                <span class="badge bg-success">
                   '.$status.'
                </span>
                 <a  class="btn btn-link" data-bs-toggle="tooltip" data-bs-placement="top" title="'.$reason.'">
                   <small> View Comment </small>
                </a>
            ';
        }elseif($status == "Queried"){
            echo '
                <span class="badge bg-warning">
                   '.$status.'
                </span>
                 <a  class="btn btn-link" data-bs-toggle="tooltip" data-bs-placement="top" title="'.$reason.'">
                    <small> View Comment </small>
                </a>
            ';
        }elseif($status == "Rejected"){
             echo '
                <span class="badge bg-danger">
                   '.$status.'
                </span>
                 <a  class="btn btn-link" data-bs-toggle="tooltip" data-bs-placement="top" title="'.$reason.'">
                    <small> View Comment </small>
                </a>
            ';
        }else{
             echo '
                <span class="badge bg-secondary">
                   '.$status.'
                </span>
                 <a  class="btn btn-link" data-bs-toggle="tooltip" data-bs-placement="top" title="'.$reason.'">
                    <small> View Comment </small>
                </a>
            ';
        }
    }
    
	function uploadFile($file, $target_dir) {
		$value = "";
		$original_name = $file["name"];
		$target_file = $target_dir . basename($original_name);

		// Check if file already exists
		$counter = 1;
		while (file_exists($target_file)) {
			$new_name = pathinfo($original_name, PATHINFO_FILENAME) . "_" . $counter . "." . pathinfo($original_name, PATHINFO_EXTENSION);
			$target_file = $target_dir . $new_name;
			$counter++;
		}

		// Check file size
		if ($file["size"] > 500000) {
			//$value .= "Sorry, your file is too large. ";
			//return $value;
			$value .= "error";
		}

		// Allow only certain file formats
		$allowed_types = array("jpg", "jpeg", "png", "gif");
		$file_extension = strtolower(pathinfo($target_file, PATHINFO_EXTENSION));
		if (!in_array($file_extension, $allowed_types)) {
			//$value .= "Sorry, only JPG, JPEG, PNG, and GIF files are allowed. ";
			$value .= "error";
			//return $value
		}

		// Try to upload the file
		if (move_uploaded_file($file["tmp_name"], $target_file)) {
			
			//return "The file " . htmlspecialchars(basename($target_file)) . " has been uploaded.";
			$uploaded = htmlspecialchars(basename($target_file));
		} else {
			$uploaded = "error";
			
		}
		
			return $uploaded;
		
		
	}

 function getCommand($commandId){
        $results = DB::queryFirstRow("SELECT * FROM command WHERE command_code=%s", $commandId);
        $array=[];
        if($results==true){
            $array['command_name'] = $results['command_name'];
            $array['command_code'] = $results['command_code'];
        }else{
            $array['command_name'] = 'N/A';
            $array['command_code'] = 'N/A';
        }
    return $array;
    }
  
  function getStatusIcon($status){
        if($status=='Active'){
            $icon = '<i class="fas fa-check-circle text-success"></i>';
        }elseif($status=='Pending'){
             $icon = '<i class="fas fa-edit text-warning"></i>';
        }else{
             $icon = '<i class="fas exclamation-triangle text-danger"></i>';
        }
    return $icon;
    }

function getDirectors($companyRCNo, $designation){
        $results = DB::queryFirstRow("SELECT * FROM directors WHERE company_rc_no=%s AND designation=%s", $companyRCNo, $designation);
        $array=[];
        if($results==true){
            $array['surname'] = $results['surname'];
            $array['firstname'] = $results['firstname'];
            $array['othername'] = $results['othername'];
            $array['phone'] = $results['phone'];
            $array['email'] = $results['email'];
            $array['religion'] = $results['religion'];
            $array['designation'] = $results['designation'];
        }else{
            $array['surname'] = 'N/A';
            $array['firstname'] = 'N/A';
            $array['othername'] = 'N/A';
            $array['phone'] = 'N/A';
            $array['email'] = 'N/A';
            $array['religion'] = 'N/A';
            $array['designation'] = 'N/A';
        }
    return $array;
    }


function getDirectorDetails($directorId){
        $results = DB::queryFirstRow("SELECT * FROM directors WHERE director_id=%i", $directorId);
        $array=[];
        if($results==true){
            $array['surname'] = $results['surname'];
            $array['firstname'] = $results['firstname'];
            $array['othername'] = $results['othername'];
            $array['phone'] = $results['phone'];
            $array['nin'] = $results['nin'];
            $array['other_lp'] = $results['other_lp'];
            $array['email'] = $results['email'];
            $array['gender'] = $results['gender'];
            $array['religion'] = $results['religion'];
            $array['passport'] = $results['passport'];
            $array['designation'] = $results['designation'];
            $array['home_address'] = $results['home_address'];
        }else{
            $array['surname'] = 'N/A';
            $array['firstname'] = 'N/A';
            $array['othername'] = 'N/A';
            $array['phone'] = 'N/A';
            $array['nin'] = 'N/A';
            $array['other_lp'] = 'N/A';
            $array['email'] = 'N/A';
            $array['gender'] = 'N/A';
            $array['religion'] = 'N/A';
            $array['passport'] = 'N/A';
            $array['designation'] = 'N/A';
            $array['home_address'] = 'N/A';
        }
    return $array;
    }

function getAuthUserDetails($authUserId){
        $results = DB::queryFirstRow("SELECT * FROM singlePage_authorized_users WHERE auth_user_id=%i", $authUserId);
        $array=[];
        if($results==true){
            $array['surname'] = $results['surname'];
            $array['firstname'] = $results['firstname'];
            $array['othername'] = $results['othername'];
            $array['phone'] = $results['phone'];
            $array['nin'] = $results['nin'];
            $array['other_lp'] = $results['other_lp'];
            $array['email'] = $results['email'];
            $array['tin'] = $results['tin'];
            $array['gender'] = $results['gender'];
            $array['religion'] = $results['religion'];
            $array['status'] = $results['status'];
            $array['passport'] = $results['passport'];
            $array['designation'] = $results['designation'];
            $array['home_address'] = $results['home_address'];
            
        }else{
            $array['surname'] = 'N/A';
            $array['firstname'] = 'N/A';
            $array['othername'] = 'N/A';
            $array['phone'] = 'N/A';
            $array['nin'] = 'N/A';
            $array['other_lp'] = 'N/A';
            $array['email'] = 'N/A';
            $array['gender'] = 'N/A';
            $array['religion'] = 'N/A';
            $array['status'] = 'N/A';
            $array['passport'] = 'N/A';
            $array['designation'] = 'N/A';
            $array['home_address'] = 'N/A';
        }
    return $array;
    }
    
    function getAuthUserOperationCommand($oprId){
        $results = DB::queryFirstRow("SELECT * FROM licence_authorized_users WHERE operational_command_id=%i", $oprId);
        $array=[];
        if($results==true){
            $array['auth_user_id'] = $results['auth_user_id'];
        }else{
            $array['auth_user_id'] = 'N/A';
        }
    return $array;
    }


    function getTransmissionRecord($authUserId){
        $results = DB::queryFirstRow("SELECT * FROM singlePage_transmit WHERE auth_user_id=%i AND command_code=%s", $authUserId, $_SESSION['command_code']);
        $array=[];
        if($results==true){
            $array['status'] = $results['status'];
        }else{
            $array['status'] = 'N/A';
        }
    return $array;
    }
    
function getLinkedLicences($directorId){
        $results = DB::queryFirstRow("SELECT COUNT(director_id) AS licences FROM licence_directors WHERE director_id=%i AND status=%s", $directorId, 'Active');
        $array=[];
        if($results==true){
            $array['licences'] = $results['licences'];
        }else{
             $array['licences'] = 'N/A';
        }
    return $array;
    }
 
 
 function getLinkedLicencesAuthUser($authUserId){
        $results = DB::queryFirstRow("SELECT COUNT(auth_user_id) AS licences FROM licence_authorized_users WHERE auth_user_id=%i AND status=%s", $authUserId, 'Active');
        $array=[];
        if($results==true){
            $array['licences'] = $results['licences'];
        }else{
             $array['licences'] = 'N/A';
        }
    return $array;
    }
    

function getAuthUserPerLicences($applicationId, $applicantId, $command){
        $results = DB::queryFirstRow("SELECT COUNT(auth_user_id) AS licences FROM licence_authorized_users WHERE applicant_id='$applicantId' AND operational_command_id='$command' AND application_id=%i AND (status=%s||status=%s)", $applicationId, 'Active', 'Pending');
        $array=[];
        if($results==true){
            $array['licences'] = $results['licences'];
        }else{
             $array['licences'] = 'N/A';
        }
    return $array;
    }
    
 function getLicence($code){
        $results = DB::queryFirstRow("SELECT * FROM licence_category WHERE licence_code=%s", $code);
        $array=[];
        if($results==true){
            $array['licence_name'] = $results['licence_name'];
        }else{
             $array['licence_name'] = 'N/A';
        }
    return $array;
    }  

function getPassport($svn){
        $results = DB::queryFirstRow("SELECT * FROM passports WHERE svn=%s", $svn);
        $array=[];
        if($results==true){
            $array['pass_name'] = $results['pass_name'];
        }else{
            $array['pass_name'] = '';
        }
    return $array;
    }

function getApplicantDetail($applicantId){
        $results = DB::queryFirstRow("SELECT * FROM applicants WHERE applicant_id=%i", $applicantId);
        $array=[];
        if($results==true){
            $array['tin'] = $results['tin'];
            $array['fullname'] = $results['fullname'];
            $array['phone'] = $results['phone'];
            $array['email'] = $results['email'];
            $array['company_name'] = $results['company_name'];
            $array['rc_number'] = $results['rc_number'];
            $array['payment_message'] = $results['payment_message'];
            $array['remitta_reference'] = $results['remitta_reference'];
            $array['payment_status'] = $results['payment_status'];
            $array['date_created'] = $results['date_created'];
        }else{
            $array['tin'] = 'N/A';
            $array['fullname'] = 'N/A';
            $array['phone'] = 'N/A';
            $array['email'] = 'N/A';
            $array['company_name'] = 'N/A';
            $array['rc_number'] = 'N/A';
            $array['payment_message'] = 'N/A';
            $array['gender'] = 'N/A';
            $array['remitta_reference'] = 'N/A';
            $array['payment_status'] = 'N/A';
            $array['date_created'] = 'N/A';
        }
    return $array;
    }
  
  function getSinglePageApplicantDetail($tin){
        $results = DB::queryFirstRow("SELECT * FROM singlePage_applicants WHERE tin=%s", $tin);
        $array=[];
        if($results==true){
            $array['licence'] = $results['licence'];
        }else{
            $array['licence'] = 'N/A';
        }
    return $array;
    }
    
  
  function getApplicationDetails($applicationId){
        $results = DB::queryFirstRow("SELECT * FROM applications WHERE application_id=%i", $applicationId);
        $array=[];
        if($results==true){
            $array['command_code'] = $results['command_code'];
            $array['licence_code'] = $results['licence_code'];
            $array['old_licence'] = $results['old_licence'];
            $array['new_licence'] = $results['new_licence'];
            $array['applicant_id'] = $results['applicant_id'];
            $array['ref_no'] = $results['ref_no'];
            $array['application_status'] = $results['application_status'];
            $array['timestamp'] = $results['timestamp'];
            $array['date_created'] = $results['date_created'];
             $array['review_comment'] = $results['review_comment'];
            $array['process_comment'] = $results['process_comment'];
        }else{
            $array['command_code'] = 'N/A';
            $array['licence_code'] = 'N/A';
            $array['old_licence'] = 'N/A';
            $array['new_licence'] = 'N/A';
            $array['applicant_id'] = 'N/A';
            $array['ref_no'] = 'N/A';
            $array['application_status'] = 'N/A';
            $array['timestamp'] = 'N/A';
            $array['date_created'] = 'N/A';
        }
    return $array;
    }
    
function getOperationalCommands($oprId){
        $results = DB::queryFirstRow("SELECT * FROM operational_command WHERE opr_id=%i", $oprId);
        $array=[];
        if($results==true){
            $array['applicant_id'] = $results['applicant_id'];
            $array['application_id'] = $results['application_id'];
            $array['licence_code'] = $results['licence_code'];
            $array['command_code'] = $results['command_code'];
            $array['process_comment'] = $results['process_comment'];
             $array['activate_comment'] = $results['activate_comment'];
            $array['timestamp'] = $results['timestamp'];
            $array['status'] = $results['status'];
            $array['date_created'] = $results['date_created'];
        }else{
            $array['applicant_id'] = 'N/A';
            $array['application_id'] = 'N/A';
            $array['licence_code'] = 'N/A';
            $array['command_code'] = 'N/A';
            $array['comment'] = 'N/A';
            $array['command'] = 'N/A';
            $array['timestamp'] = 'N/A';
            $array['status'] = 'N/A';
            $array['date_created'] = 'N/A';
        }
    return $array;
    }    
    
 function getBondInformation($applicationId){
        $results = DB::queryFirstRow("SELECT * FROM bond_information WHERE application_id=%i", $applicationId);
        $array=[];
        if($results==true){
            $array['bond_ref'] = $results['bond_ref'];
            $array['created_by'] = $results['created_by'];
            $array['status'] = $results['status'];
            $array['timestamp'] = $results['timestamp'];
            $array['date_created'] = $results['date_created'];
            
        }else{
            $array['bond_ref'] = 'N/A';
            $array['created_by'] = 'N/A';
            $array['status'] = 'N/A';
            $array['timestamp'] = 'N/A';
            $array['date_created'] = 'N/A';
        }
    return $array;
    }

function getState($stateId){
        $results = DB::queryFirstRow("SELECT * FROM state WHERE state_id=%i", $stateId);
        $array=[];
        if($results==true){
            $array['state_name'] = $results['state_name'];
        }else{
            $array['state_name'] = 'N/A';
        }
         return $array;
   
    }
    
//GET THE NUMBER OF FLATS (UNITS) IN EACH BARRACKS
function getNumberofUnits($barrackId){
    $results = DB::queryFirstRow("SELECT * FROM barrack_unit_information WHERE barrack_id='$barrackId'");
    if ($results) {
        $row_count = DB::count();
    }else{
        $row_count='0';
    }
    return $row_count;
}


//GET THE NUMBER OF FLATS IMAGES
function getNumberofUnitImages($unitId){
    $results = DB::queryFirstRow("SELECT * FROM barrack_unit_images WHERE unit='$unitId'");
    if ($results) {
        $row_count = DB::count();
    }else{
        $row_count='0';
    }
    return $row_count;
}

function getUnitImages($imageId){
        $results = DB::queryFirstRow("SELECT * FROM barrack_unit_images WHERE image_id=%i", $imageId);
        $array=[];
        if($results==true){
            $array['image_title'] = $results['image_title'];
            $array['description'] = $results['description'];
        }else{
            $array['image_title'] = 'N/A';
            $array['description'] = 'N/A';
        }
         return $array;
   
    }
    
function getLGA($lgaId){
        $results = DB::queryFirstRow("SELECT * FROM local_govt WHERE lga_id=%i", $lgaId);
        $array=[];
        if($results==true){
            $array['local_govt'] = $results['local_govt'];
        }else{
            $array['local_govt'] = 'N/A';
        }
    return $array;
    }
    
    
function getKinRelationship($Id){
        $results = DB::queryFirstRow("SELECT * FROM kin_relationship WHERE id=%i", $Id);
        $array=[];
        if($results==true){
            $array['name'] = $results['name'];
        }
    return $array;
    }
    
function getNextKin($svn){
        $results = DB::queryFirstRow("SELECT * FROM kin_information WHERE svn=%s", $svn);
        $array=[];
        if($results==true){
            $array['fullname'] = $results['fullname'];
            $rel = getKinRelationship($results['relationship']);
            $array['relationship'] = $rel['name'];
            $array['phone'] = $results['phone'];
            $array['address'] = $results['address'];
            $array['email'] = $results['email'];
            $array['gender'] = $results['gender'];
        }else{
            $array['fullname'] = 'N/A';
            $array['relationship'] = 'N/A';
            $array['phone'] = 'N/A';
            $array['address'] = 'N/A';
            $array['email'] = 'N/A';
            $array['gender'] = 'N/A';
        }
    return $array;
    }
    
    
    function getRank($rankId){
        $results = DB::queryFirstRow("SELECT * FROM ranks WHERE rank_id=%i", $rankId);
        $array=[];
        if($results==true){
            $array['rank_id'] = $results['rank_id'];
            $array['rank_name'] = $results['rank_name'];
             $array['rank_code'] = $results['rank_code'];
        }
    return $array;
    }
function getDepartment($departmentId){
        $results = DB::queryFirstRow("SELECT * FROM department WHERE department_id=%i", $departmentId);
        $array=[];
        if($results==true){
            $array['department_id'] = $results['department_id'];
            $array['department_name'] = $results['department_name'];
             $array['department_code'] = $results['department_code'];
             $array['department_head'] = $results['department_head'];
        }
    return $array;
    }
    
function getDesignation($designationId){
        $results = DB::queryFirstRow("SELECT * FROM designation WHERE designation_id=%i", $designationId);
        $array=[];
        if($results==true){
            $array['designation_id'] = $results['designation_id'];
            $array['designation_name'] = $results['designation_name'];
        }
    return $array;
    }
    
 function getHeadquarterUnits($commId){
        $query = DB::query("SELECT * FROM unit WHERE command_id=%i", $commId);
        
        if($query==true){
            $unit = ' <option value="">Select Unit</option>';
                foreach($query as $results){
                    $unit .="<option value='".$results['unit_id']."'>".$results['unit_name']."</option>";
                }
        }else{
            $unit = '<option>No Unit</option>';
        }
        return $unit;
    }


 function getDesignationDropDown($departmentId){
        $query = DB::query("SELECT * FROM designation WHERE department_id=%i", $departmentId);
        
        if($query==true){
            $designation = ' <option value="">Select Designation</option>';
                foreach($query as $results){
                    $designation .="<option value='".$results['designation_id']."'>".$results['designation_name']."</option>";
                }
        }else{
            $designation = '<option>No Designation</option>';
        }
        return $designation;
    }




function getBarrackUnitDropdown($barrackId){
        $query = DB::query("SELECT * FROM barrack_unit_information WHERE barrack_id=%i AND allocation_status=%s", $barrackId, 'Available');
        
        if($query==true){
            $barrackUnit = ' <option value="">Select Barrack Unit</option>';
                foreach($query as $results){
                    $barrackUnit .="<option value='".$results['barrack_unit_id']."'>".$results['unit_code']."</option>";
                }
        }else{
            $barrackUnit = '<option>No Barrack Unit</option>';
        }
        return $barrackUnit;
    }

function getLGADropdown($stateId){
        $record = DB::query("SELECT * FROM local_govt WHERE state_id =%i", $stateId);
        if ($record==true) {
           $lga = '<option value="" hidden> -- Select LGA -- </option>';

          foreach($record as $class) {
            $lga .= '<option value="' .$class['lga_id']. '">'.$class['local_govt'].'</option>';
          }
            
          }else{
            $lga = '<option value="">No LGA</option>';
          } 
        return $lga;               
}

function getUserDetail($svn){
        $results = DB::queryFirstRow("SELECT * FROM users WHERE svc=%i", $svn);
        $array=[];
        if($results==true){
            $array['username'] = $results['username'];
            $array['fullname'] = $results['fullname'];
            $array['svc'] = $results['svc'];
            $array['phone'] = $results['phone'];
            $array['rank_id'] = $results['rank_id'];
            $array['department_id'] = $results['department'];
            $array['command_id'] = $results['command_id'];
            $array['date_created'] = $results['date_created'];
        }
    return $array;
    }
    

 

	function getBarrackDetails($barrackId){
		$results = DB::queryFirstRow("SELECT * FROM barrack_information WHERE barrack_id=%i", $barrackId);
		$array=[];
		if ($results==true) {
			$array['name'] = $results['name'];
			$array['barrack_code'] = $results['barrack_code'];
			$array['category'] = $results['category'];
			$array['address'] = $results['address'];
			$array['barrack_state'] = $results['barrack_state'];
			$array['barrack_lga'] = $results['barrack_lga'];
		}else{
		    $array['name'] = 'N/A';
		    $array['barrack_code'] = 'N/A';
			$array['category'] = 'N/A';
			$array['address'] = 'N/A';
			$array['barrack_state'] = 'N/A';
			$array['barrack_lga'] = 'N/A';
		}
		return $array;
	}

	function getBarrackUnitDetails($barrackUnitId){
		$results = DB::queryFirstRow("SELECT * FROM barrack_unit_information WHERE barrack_unit_id=%i", $barrackUnitId);
		$array=[];
		if ($results==true) {
			$array['unit_name'] = $results['unit_name'];
			$array['unit_code'] = $results['unit_code'];
			$array['unit_status'] = $results['unit_status'];
			$array['barrack_id'] = $results['barrack_id'];
			$array['facilities'] = $results['facilities'];
			$array['allocation_status'] = $results['allocation_status'];
		}else{
		    $array['unit_name'] = 'N/A';
			$array['unit_status'] = 'N/A';
			$array['unit_code'] = 'N/A';
			$array['barrack_id'] = 'N/A';
			$array['facilities'] = 'N/A';
			$array['allocation_status'] = 'N/A';
		}
		return $array;
	}
	
	function getAllocationDetails($allocationId){
		$results = DB::queryFirstRow("SELECT * FROM allocation WHERE allocation_id=%i", $allocationId);
		$array=[];
		if ($results==true) {
			$array['tracking_id'] = $results['tracking_id'];
			$array['svn'] = $results['svn'];
			$array['rank'] = $results['rank'];
			$array['command'] = $results['command'];
			$array['unit'] = $results['unit'];
			$array['description'] = $results['description'];
			$array['status'] = $results['status'];
			$array['decision'] = $results['decision'];
			$array['decision_date'] = $results['decision_date'];
			$array['application_date'] = $results['application_date'];
			$array['decision_reason'] = $results['decision_reason'];
			$array['move_out_date'] = $results['move_out_date'];
			$array['move_out_reason'] = $results['move_out_reason'];
			$array['decision_by'] = $results['decision_by'];
			$array['moved_out_by'] = $results['moved_out_by'];
		}else{
		    $array['tracking_id'] = 'N/A';
			$array['svn'] = 'N/A';
			$array['rank'] = 'N/A';
			$array['command'] = 'N/A';
			$array['unit'] = 'N/A';
			$array['description'] = 'N/A';
			$array['status'] = 'N/A';
			$array['decision'] = 'N/A';
			$array['decision_date'] = 'N/A';
			$array['application_date'] = 'N/A';
			$array['decision_reason'] = 'N/A';
			$array['move_out_date'] = 'N/A';
			$array['move_out_reason'] = 'N/A';
			$array['decision_by'] = 'N/A';
			$array['moved_out_by'] = 'N/A';
		
		}
			return $array;
	}	
function getCountry($countryId){
        $results = DB::queryFirstRow("SELECT * FROM country WHERE country_id=%i", $countryId);
        $countryDetails=[];
        if($results==true){
            $countryDetails['country_name'] = $results['country_name'];
            $countryDetails['country_id'] = $results['country_id'];
            //$countryDetails['date_created'] = $results['date_created'];
        }
        return $countryDetails;
    }
    

function getBarrackUnitImages($barrackUnitId) {
    // Perform the database query to fetch up to 8 rows
    $results = DB::query("SELECT image_url, image_title FROM barrack_unit_images WHERE unit = %i ORDER BY image_id LIMIT 8", $barrackUnitId);

    $array = [];

    for ($i = 1; $i <= 8; $i++) {
        if (isset($results[$i - 1])) {
            $array['image' . $i] = $results[$i - 1]['image_url'];
            $array['imageTitle' . $i] = $results[$i - 1]['image_title'];
        } else {
            $array['image' . $i] = '';
            $array['imageTitle' . $i] = 'No Image';
        }
    }

    return $array;
}


	
function getEmailNotification($emailId, $emailSubject, $emailMessage){
        
        
    require 'phpmailer/src/Exception.php';
    require 'phpmailer/src/PHPMailer.php';
    require 'phpmailer/src/SMTP.php';
    
    // Instantiation and passing `true` enables exceptions
    $mail = new PHPMailer(true);

try {
    //Server settings
    // $mail->SMTPDebug = SMTP::DEBUG_SERVER;                      // Enable verbose debug output
    $mail->isSMTP();                                            // Send using SMTP
    $mail->Host       = 'licences.customs.gov.ng';                    // Set the SMTP server to send through
    $mail->SMTPAuth   = true;                                   // Enable SMTP authentication
    $mail->Username   = 'info@licences.customs.gov.ng';                     // SMTP username
    $mail->Password   = '@Change12345';                               // SMTP password
    $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;         // Enable TLS encryption; `PHPMailer::ENCRYPTION_SMTPS` also accepted
    $mail->Port       = 587;                                    // TCP port to connect to

    //Recipients
    $mail->setFrom('info@licences.customs.gov.ng', 'NIGERIA CUSTOMS SERVICE');
    $mail->addAddress($emailId);     // Add a recipient
    $link = urlencode($emailLink);
    // Content
    $mail->isHTML(true);                                  // Set email format to HTML
    $mail->Subject = $emailSubject;
    $mail->Body    = $emailMessage;
    // $mail->AltBody = 'This is the body in plain text for non-HTML mail clients';

    $mail->send();
    } catch (Exception $e) {
    echo "Message could not be sent. Mailer Error: {$mail->ErrorInfo}";
    }
##########end of email##########3333
    }
    return null;
?>